<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Facebook Video Analytics - Login</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .login-container {
            max-width: 500px;
            margin: 100px auto;
            padding: 30px;
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
        }
        .btn-facebook {
            background-color: #3b5998;
            color: white;
        }
        .btn-facebook:hover {
            background-color: #2d4373;
            color: white;
        }
        .logo {
            text-align: center;
            margin-bottom: 30px;
        }
        .logo h1 {
            color: #3b5998;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="login-container">
            <div class="logo">
                <h1>Facebook Video Analytics</h1>
                <p class="text-muted">Análise de vídeos e público-alvo</p>
            </div>
            
            @if(session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif
            
            <div class="text-center">
                <p class="mb-4">Faça login com sua conta do Facebook para analisar os vídeos da sua página</p>
                
                <a href="{{ route('auth.facebook') }}" class="btn btn-facebook btn-lg w-100 mb-3">
                    <i class="bi bi-facebook me-2"></i> Entrar com Facebook
                </a>
                
                <p class="mt-4 text-muted small">
                    Ao fazer login, você concorda com os nossos termos de serviço e política de privacidade.
                    Esta aplicação solicitará permissões para acessar dados de vídeos e insights das suas páginas.
                </p>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
