<?php

use App\Http\Controllers\DashboardController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\VideoController;
use App\Http\Controllers\MetricsController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\FacebookController;
use Illuminate\Support\Facades\Auth;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

// Rotas de autenticação do Facebook
Route::get('auth/facebook', [FacebookController::class, 'redirectToFacebook'])->name('auth.facebook');
Route::get('auth/facebook/callback', [FacebookController::class, 'handleFacebookCallback'])->name('auth.facebook.callback');

// Rota de logout
Route::post('/logout', function () {
    Auth::logout();
    return redirect('/');
})->name('logout');

// Rotas protegidas por autenticação
Route::middleware(['auth'])->group(function () {
    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    
    // Páginas
    Route::get('/pages', [PageController::class, 'index'])->name('pages.index');
    Route::get('/pages/import', [PageController::class, 'import'])->name('pages.import');
    Route::get('/pages/{id}', [PageController::class, 'show'])->name('pages.show');
    Route::delete('/pages/{id}', [PageController::class, 'destroy'])->name('pages.destroy');
    
    // Vídeos
    Route::get('/videos', [VideoController::class, 'index'])->name('videos.index');
    Route::get('/pages/{pageId}/videos/import', [VideoController::class, 'import'])->name('videos.import');
    Route::get('/videos/{id}', [VideoController::class, 'show'])->name('videos.show');
    Route::get('/videos/{id}/update-metrics', [VideoController::class, 'updateMetrics'])->name('videos.update-metrics');
    
    // Métricas e Análises
    Route::get('/metrics', [MetricsController::class, 'index'])->name('metrics.index');
    Route::get('/metrics/compare', [MetricsController::class, 'compare'])->name('metrics.compare');
    Route::get('/metrics/audience', [MetricsController::class, 'audience'])->name('metrics.audience');
    Route::get('/metrics/topics', [MetricsController::class, 'topics'])->name('metrics.topics');
});
