#!/bin/bash

# Script de teste para a aplicação Facebook Ad Video Analytics
# Este script verifica se todos os componentes necessários estão presentes e funcionando

echo "Iniciando testes da aplicação Facebook Ad Video Analytics..."
echo "-------------------------------------------------------"

# Verificar estrutura de diretórios
echo "Verificando estrutura de diretórios..."
DIRECTORIES=(
    "app/Http/Controllers"
    "app/Models"
    "app/Services"
    "resources/views"
    "routes"
    "docs"
)

for dir in "${DIRECTORIES[@]}"; do
    if [ -d "$dir" ]; then
        echo "✓ Diretório $dir encontrado"
    else
        echo "✗ Diretório $dir não encontrado"
    fi
done

echo ""

# Verificar arquivos principais
echo "Verificando arquivos principais..."
FILES=(
    "app/Services/AdLibraryService.php"
    "app/Services/TopicCategorizer.php"
    "app/Services/ThirdPartyVideoAnalyzer.php"
    "app/Http/Controllers/ThirdPartyAnalysisController.php"
    "app/Models/Topic.php"
    "app/Models/VideoAd.php"
    "routes/web.php"
    "docs/PERMISSOES_META.md"
)

for file in "${FILES[@]}"; do
    if [ -f "$file" ]; then
        echo "✓ Arquivo $file encontrado"
    else
        echo "✗ Arquivo $file não encontrado"
    fi
done

echo ""

# Verificar dependências
echo "Verificando dependências..."
if command -v php &> /dev/null; then
    PHP_VERSION=$(php -v | head -n 1)
    echo "✓ PHP instalado: $PHP_VERSION"
else
    echo "✗ PHP não encontrado"
fi

if command -v composer &> /dev/null; then
    COMPOSER_VERSION=$(composer --version | head -n 1)
    echo "✓ Composer instalado: $COMPOSER_VERSION"
else
    echo "✗ Composer não encontrado"
fi

if command -v mysql &> /dev/null; then
    MYSQL_VERSION=$(mysql --version | head -n 1)
    echo "✓ MySQL instalado: $MYSQL_VERSION"
else
    echo "✗ MySQL não encontrado"
fi

if command -v node &> /dev/null; then
    NODE_VERSION=$(node -v)
    echo "✓ Node.js instalado: $NODE_VERSION"
else
    echo "✗ Node.js não encontrado"
fi

echo ""

# Verificar configuração do ambiente
echo "Verificando configuração do ambiente..."
if [ -f ".env" ]; then
    echo "✓ Arquivo .env encontrado"
    
    # Verificar configurações do banco de dados
    DB_NAME=$(grep DB_DATABASE .env | cut -d '=' -f2)
    if [ ! -z "$DB_NAME" ]; then
        echo "✓ Nome do banco de dados configurado: $DB_NAME"
    else
        echo "✗ Nome do banco de dados não configurado"
    fi
else
    echo "✗ Arquivo .env não encontrado"
fi

echo ""

echo "Testes concluídos!"
echo "-------------------------------------------------------"
echo "Para executar a aplicação, use o comando: php artisan serve"
echo "Para acessar a documentação sobre permissões da Meta, consulte: docs/PERMISSOES_META.md"
