@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1>{{ $page->name }}</h1>
                <div>
                    <a href="{{ route('videos.import', $page->id) }}" class="btn btn-primary">
                        <i class="bi bi-cloud-download"></i> Importar Vídeos
                    </a>
                    <a href="{{ route('pages.index') }}" class="btn btn-outline-secondary ms-2">
                        <i class="bi bi-arrow-left"></i> Voltar para Páginas
                    </a>
                </div>
            </div>
            
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif
            
            @if(session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif
            
            <div class="card mb-4">
                <div class="card-header">
                    <h5>Informações da Página</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-2 text-center">
                            @if($page->profile_picture_url)
                                <img src="{{ $page->profile_picture_url }}" alt="{{ $page->name }}" class="img-fluid rounded-circle mb-3" style="max-width: 120px;">
                            @else
                                <div class="rounded-circle bg-secondary mx-auto mb-3 d-flex align-items-center justify-content-center" style="width: 120px; height: 120px;">
                                    <i class="bi bi-facebook fs-1 text-white"></i>
                                </div>
                            @endif
                        </div>
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-6">
                                    <p><strong>Nome:</strong> {{ $page->name }}</p>
                                    <p><strong>Categoria:</strong> {{ $page->category ?? 'Não especificada' }}</p>
                                    <p><strong>ID da Página:</strong> {{ $page->facebook_page_id }}</p>
                                </div>
                                <div class="col-md-6">
                                    <p><strong>Seguidores:</strong> {{ number_format($page->follower_count) }}</p>
                                    <p><strong>Adicionada em:</strong> {{ $page->created_at->format('d/m/Y H:i') }}</p>
                                    <p><strong>Token expira em:</strong> {{ $page->token_expires_at ? $page->token_expires_at->format('d/m/Y') : 'Não expira' }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5>Vídeos</h5>
                    <div class="btn-group">
                        <button type="button" class="btn btn-sm btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-funnel"></i> Filtrar
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item" href="{{ route('pages.show', $page->id) }}">Todos os vídeos</a></li>
                            <li><a class="dropdown-item" href="{{ route('pages.show', ['id' => $page->id, 'video_type' => 'regular']) }}">Vídeos regulares</a></li>
                            <li><a class="dropdown-item" href="{{ route('pages.show', ['id' => $page->id, 'video_type' => 'reel']) }}">Reels</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="{{ route('pages.show', ['id' => $page->id, 'sort' => 'views']) }}">Mais visualizados</a></li>
                            <li><a class="dropdown-item" href="{{ route('pages.show', ['id' => $page->id, 'sort' => 'date']) }}">Mais recentes</a></li>
                        </ul>
                    </div>
                </div>
                <div class="card-body">
                    @if(count($videos) > 0)
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>Thumbnail</th>
                                        <th>Título</th>
                                        <th>Tipo</th>
                                        <th>Publicado em</th>
                                        <th>Duração</th>
                                        <th>Visualizações</th>
                                        <th>Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($videos as $video)
                                        <tr>
                                            <td>
                                                @if($video->thumbnail_url)
                                                    <img src="{{ $video->thumbnail_url }}" alt="{{ $video->title }}" class="img-thumbnail" style="width: 80px;">
                                                @else
                                                    <div class="bg-secondary d-flex align-items-center justify-content-center" style="width: 80px; height: 45px;">
                                                        <i class="bi bi-film text-white"></i>
                                                    </div>
                                                @endif
                                            </td>
                                            <td>{{ $video->title ?: 'Sem título' }}</td>
                                            <td>
                                                @if($video->video_type == 'reel')
                                                    <span class="badge bg-info">Reel</span>
                                                @else
                                                    <span class="badge bg-secondary">Vídeo</span>
                                                @endif
                                            </td>
                                            <td>{{ $video->published_at->format('d/m/Y') }}</td>
                                            <td>{{ gmdate('i:s', $video->duration) }}</td>
                                            <td>
                                                @php
                                                    $viewMetric = $video->metrics->where('metric_name', 'views')->first() ?? 
                                                                 $video->metrics->where('metric_name', 'total_video_views')->first();
                                                    $views = $viewMetric ? number_format((int)$viewMetric->metric_value) : 'N/A';
                                                @endphp
                                                {{ $views }}
                                            </td>
                                            <td>
                                                <div class="btn-group">
                                                    <a href="{{ route('videos.show', $video->id) }}" class="btn btn-sm btn-info">
                                                        <i class="bi bi-graph-up"></i> Análise
                                                    </a>
                                                    <a href="{{ route('videos.update-metrics', $video->id) }}" class="btn btn-sm btn-outline-secondary">
                                                        <i class="bi bi-arrow-repeat"></i> Atualizar
                                                    </a>
                                                    @if($video->permalink_url)
                                                        <a href="{{ $video->permalink_url }}" target="_blank" class="btn btn-sm btn-outline-primary">
                                                            <i class="bi bi-facebook"></i> Ver
                                                        </a>
                                                    @endif
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="d-flex justify-content-center mt-4">
                            {{ $videos->links() }}
                        </div>
                    @else
                        <div class="alert alert-info">
                            <h4 class="alert-heading">Nenhum vídeo encontrado!</h4>
                            <p>Esta página ainda não possui vídeos importados. Clique no botão "Importar Vídeos" para começar.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
