# Pesquisa sobre APIs do Facebook para Busca Pública de Vídeos

## Resumo das Descobertas

Após uma pesquisa detalhada das APIs do Facebook, identificamos as seguintes possibilidades e limitações para buscar vídeos criativos de outros usuários:

### 1. API do Graph - Limitações Significativas

- **Vídeos de Usuários**: Requer token de acesso do usuário com permissão `user_videos`, mas isso só permite acessar:
  - Vídeos do próprio usuário
  - Vídeos em que o usuário foi marcado
  - Não permite busca de vídeos de outros usuários

- **Vídeos de Páginas**: 
  - Para páginas administradas pelo usuário: Requer token de acesso de página e permissão `pages_read_engagement`
  - Para páginas públicas não administradas pelo usuário: Seria necessário "Page Public Content Access", mas essa funcionalidade parece ter sido removida ou alterada (documentação não encontrada)

### 2. API de Marketing e Insights API

- Focadas em gerenciamento e análise de anúncios
- Permitem acessar métricas e estatísticas de anúncios, incluindo anúncios em vídeo
- Requerem permissão `ads_read`
- Não oferecem funcionalidade direta para buscar vídeos públicos de terceiros não relacionados a anúncios

### 3. Ad Library e Ad Library API

- Permite buscar anúncios ativos, incluindo anúncios em formato de vídeo
- Foco em anúncios sobre temas sociais, eleições ou política
- Permite construir buscas personalizadas usando parâmetros como tamanho estimado de audiência, país ou idioma
- Requer aprovação para acesso à API

## Conclusões e Recomendações

1. **Limitações de Acesso**: O Facebook impõe restrições significativas para proteger a privacidade dos usuários e o acesso a conteúdo de terceiros.

2. **Abordagens Possíveis**:
   - **Ad Library API**: Pode ser a melhor opção para acessar vídeos criativos usados em anúncios
   - **Marketing API com foco em anúncios**: Permite analisar vídeos usados em campanhas publicitárias
   - **Combinação de APIs**: Usar a API do Graph para páginas públicas (com as limitações existentes) e complementar com a Ad Library API

3. **Desafios Técnicos**:
   - Necessidade de aprovação para acesso a APIs específicas
   - Limitações de taxa (rate limits) para consultas
   - Métricas limitadas para conteúdo de terceiros

4. **Próximos Passos**:
   - Focar a aplicação na análise de vídeos criativos usados em anúncios através da Ad Library API
   - Implementar sistema de categorização baseado em metadados disponíveis
   - Desenvolver interface de pesquisa que permita filtrar por temas, engajamento e público-alvo
   - Solicitar as permissões necessárias da Meta para acesso às APIs relevantes
