# Métricas de Engajamento para Vídeos do Facebook

## Métricas de Vídeo Padrão

As seguintes métricas estão disponíveis para vídeos padrão no Facebook:

| Nome da Métrica | Descrição | Período Disponível |
|-----------------|-----------|-------------------|
| `total_video_views` | Número de vezes que os vídeos foram reproduzidos por pelo menos 3 segundos, ou por quase toda a sua duração se forem mais curtos que 3 segundos. Durante uma única instância de reprodução, é excluído qualquer tempo gasto repetindo o vídeo. | lifetime |
| `total_video_views_unique` | Número de pessoas que visualizaram os vídeos por pelo menos 3 segundos, ou por quase toda a sua duração se forem mais curtos que 3 segundos. | lifetime |
| `total_video_views_autoplayed` | Número de vezes que os vídeos foram reproduzidos automaticamente por pelo menos 3 segundos, ou por quase toda a sua duração se forem mais curtos que 3 segundos. | lifetime |
| `total_video_views_clicked_to_play` | Número de vezes que os vídeos foram reproduzidos por pelo menos 3 segundos após as pessoas clicarem em reproduzir. | lifetime |
| `total_video_views_organic` | Número de vezes que os vídeos foram reproduzidos por pelo menos 3 segundos por alcance orgânico. | lifetime |
| `total_video_views_organic_unique` | Número de pessoas que visualizaram os vídeos por pelo menos 3 segundos por alcance orgânico. | lifetime |
| `total_video_views_paid` | Número de vezes que os vídeos promovidos foram reproduzidos por pelo menos 3 segundos. | lifetime |
| `total_video_views_paid_unique` | Número de pessoas que visualizaram os vídeos promovidos por pelo menos 3 segundos. | lifetime |
| `total_video_views_sound_on` | Número de vezes que os vídeos foram reproduzidos com som por pelo menos 3 segundos. | lifetime |
| `total_video_complete_views` | Número de vezes que os vídeos foram reproduzidos até 95% de sua duração, incluindo reproduções que pularam para este ponto. | lifetime |
| `total_video_complete_views_unique` | Número de pessoas que visualizaram os vídeos até 95% de sua duração, incluindo reproduções que pularam para este ponto. | lifetime |
| `total_video_complete_views_auto_played` | Número de vezes que os vídeos foram reproduzidos automaticamente até 95% de sua duração. | lifetime |
| `total_video_complete_views_clicked_to_play` | Número de vezes que os vídeos foram reproduzidos até 95% de sua duração após as pessoas clicarem em reproduzir. | lifetime |
| `total_video_complete_views_organic` | Número de vezes que os vídeos foram reproduzidos até 95% de sua duração por alcance orgânico. | lifetime |
| `total_video_complete_views_organic_unique` | Número de pessoas que visualizaram os vídeos até 95% de sua duração por alcance orgânico. | lifetime |
| `total_video_complete_views_paid` | Número de vezes que os vídeos promovidos foram reproduzidos até 95% de sua duração. | lifetime |
| `total_video_complete_views_paid_unique` | Número de pessoas que visualizaram os vídeos promovidos até 95% de sua duração. | lifetime |
| `total_video_10s_views` | Número de vezes que os vídeos foram reproduzidos por pelo menos 10 segundos, ou por quase toda a sua duração se forem mais curtos que 10 segundos. | lifetime |
| `total_video_10s_views_unique` | Número de pessoas que visualizaram os vídeos por pelo menos 10 segundos, ou por quase toda a sua duração se forem mais curtos que 10 segundos. | lifetime |
| `total_video_10s_views_auto_played` | Número de vezes que os vídeos foram reproduzidos automaticamente por pelo menos 10 segundos. | lifetime |
| `total_video_10s_views_clicked_to_play` | Número de vezes que os vídeos foram reproduzidos por pelo menos 10 segundos após as pessoas clicarem em reproduzir. | lifetime |
| `total_video_10s_views_organic` | Número de vezes que os vídeos foram reproduzidos por pelo menos 10 segundos por alcance orgânico. | lifetime |
| `total_video_10s_views_paid` | Número de vezes que os vídeos promovidos foram reproduzidos por pelo menos 10 segundos. | lifetime |
| `total_video_10s_views_sound_on` | Número de vezes que os vídeos foram reproduzidos com som por pelo menos 10 segundos. | lifetime |
| `total_video_avg_time_watched` | Tempo médio (em milissegundos) que os vídeos foram reproduzidos, incluindo tempo gasto repetindo partes dos vídeos. | lifetime |
| `total_video_view_total_time` | Tempo total (em milissegundos) que os vídeos foram reproduzidos, incluindo tempo gasto repetindo partes dos vídeos. | lifetime |
| `total_video_view_total_time_organic` | Tempo total (em milissegundos) que os vídeos foram reproduzidos por alcance orgânico. | lifetime |
| `total_video_view_total_time_paid` | Tempo total (em milissegundos) que os vídeos promovidos foram reproduzidos. | lifetime |

## Métricas de Reels

As seguintes métricas estão disponíveis para Reels no Facebook:

| Nome da Métrica | Descrição | Período Disponível |
|-----------------|-----------|-------------------|
| `blue_reels_play_count` | Número de vezes que o reel começou a ser reproduzido após uma impressão já ter sido contabilizada. Esta métrica conta sessões de reels com 1 milissegundo ou mais de reprodução. Esta métrica exclui repetições. | lifetime |
| `fb_reels_replay_count` | Número de vezes que o reel começou a ser reproduzido novamente após uma reprodução inicial. Isso é definido como repetições de 1 milissegundo ou mais na mesma sessão de reel. | lifetime |
| `fb_reels_total_plays` | Número de vezes que o reel começou a ser reproduzido após uma impressão já ter sido contabilizada. Isso é definido como sessões de reel com 1 milissegundo ou mais e inclui repetições. As repetições são contadas após a reprodução inicial do reel na mesma sessão. | lifetime |
| `post_impressions_unique` | Número de pessoas que viram o reel pelo menos uma vez, independentemente de terem reproduzido o reel ou não. Esta métrica é diferente de impressões, que inclui várias visualizações do reel pela mesma pessoa. Esta métrica é estimada. | lifetime |
| `post_video_avg_time_watched` | Tempo médio (em milissegundos) que o reel foi reproduzido durante uma única instância de reprodução, incluindo o tempo gasto repetindo o reel. Como esta métrica inclui repetições, o valor pode ser maior que a duração total do reel. | lifetime |
| `post_video_followers` | Número de seguidores para o reel. | lifetime |
| `post_video_likes_by_reaction_type` | Número de curtidas no reel. | lifetime |
| `post_video_retention_graph` | Porcentagem de vezes que o reel foi reproduzido em vários segmentos de timestamp do número total de reproduções. A maioria dos reels começará com 100% de retenção e diminuirá à medida que as reproduções começarem a cair. Se alguém pulou o início do reel, sua curva começará no timestamp onde o reel começou a ser reproduzido. | lifetime |
| `post_video_social_actions` | Número de comentários no reel e número de vezes que o reel foi compartilhado. | lifetime |
| `post_video_view_time` | Tempo total (em milissegundos) que o reel foi reproduzido, incluindo o tempo gasto repetindo o reel. | lifetime |

## Métricas de Ad Breaks (Intervalos Comerciais)

As seguintes métricas estão disponíveis para intervalos comerciais em vídeos:

| Nome da Métrica | Descrição | Período Disponível |
|-----------------|-----------|-------------------|
| `total_video_ad_break_ad_cpm` | Valor médio pago por anunciantes por 1.000 impressões de seus anúncios em seu vídeo, em centavos de dólar americano. Este número também inclui o valor pago ao Facebook. | day, lifetime |
| `total_video_ad_break_ad_impressions` | Número de vezes que um anúncio foi exibido durante os intervalos comerciais do seu vídeo. | day, lifetime |
| `total_video_ad_break_earnings` | Estimativa do valor ganho com intervalos comerciais em seu vídeo, em centavos de dólar americano, com base no número de impressões e CPM dos anúncios exibidos. Os pagamentos reais podem diferir se houver reivindicações de propriedade de conteúdo ou outros ajustes. | day, lifetime |
| `creator_monetization_qualified_views` | Número de visualizações do seu vídeo que receberão pagamento. | day, lifetime |

## Métricas Demográficas e de Segmentação

Além das métricas específicas de vídeo, o Facebook também fornece métricas demográficas para entender melhor o público que está interagindo com os vídeos:

1. **Dados Demográficos**:
   - Idade
   - Gênero
   - Localização (país, cidade)
   - Idioma

2. **Métricas de Engajamento por Demografia**:
   - Visualizações por faixa etária
   - Visualizações por gênero
   - Visualizações por localização
   - Tempo de visualização por demografia

## Limitações Importantes

1. **Disponibilidade de Dados**:
   - Dados disponíveis apenas para os últimos 2 anos
   - Métricas demográficas disponíveis apenas se houver dados para 100+ pessoas
   - Limite de 90 dias para visualização de insights de uma vez

2. **Precisão de Métricas**:
   - Algumas métricas de vídeo só retornam valores precisos para o criador do vídeo
   - Se você compartilhar um vídeo de outra Página e recuperar seus insights, as métricas retornarão um valor de 0

3. **Atualização de Dados**:
   - A maioria das métricas é atualizada uma vez a cada 24 horas

4. **Requisitos de Página**:
   - Dados de Insights de Página disponíveis apenas em Páginas com 100 ou mais curtidas

## Parâmetros de Consulta

Ao consultar métricas de vídeo através da API, você pode usar os seguintes parâmetros:

| Parâmetro | Descrição |
|-----------|-----------|
| `metric` | Lista de métricas que você deseja receber |
| `period` | Período de agregação (day, week, days_28, month, lifetime, total_over_range) |
| `since` | Limite inferior do intervalo de tempo a considerar |
| `until` | Limite superior do intervalo de tempo a considerar |

## Exemplo de Resposta da API

A resposta da API para métricas de vídeo segue este formato:

```json
{
  "data": [
    {
      "name": "total_video_views",
      "period": "lifetime",
      "values": [
        {
          "value": 89
        }
      ],
      "title": "Lifetime Total Video Views",
      "description": "Lifetime: Total number of times your video was viewed for 3 seconds or viewed to the end, whichever came first. (Total Count)",
      "id": "323790578640877/video_insights/total_video_views/lifetime"
    },
    {
      "name": "total_video_views_unique",
      "period": "lifetime",
      "values": [
        {
          "value": 56
        }
      ],
      "title": "Lifetime Unique Video Views",
      "description": "Lifetime: Number of unique people who viewed your video for 3 seconds or viewed to the end, whichever came first. (Unique Users)",
      "id": "323790578640877/video_insights/total_video_views_unique/lifetime"
    }
  ]
}
```
