@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1>Páginas do Facebook</h1>
                <a href="{{ route('pages.import') }}" class="btn btn-primary">
                    <i class="bi bi-cloud-download"></i> Importar Páginas
                </a>
            </div>
            
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif
            
            @if(session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif
            
            @if(count($pages) > 0)
                <div class="row">
                    @foreach($pages as $page)
                        <div class="col-md-6 col-lg-4 mb-4">
                            <div class="card h-100">
                                <div class="card-header d-flex align-items-center">
                                    @if($page->profile_picture_url)
                                        <img src="{{ $page->profile_picture_url }}" alt="{{ $page->name }}" class="rounded-circle me-2" style="width: 40px; height: 40px;">
                                    @else
                                        <div class="rounded-circle bg-secondary me-2 d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                            <i class="bi bi-facebook text-white"></i>
                                        </div>
                                    @endif
                                    <h5 class="card-title mb-0">{{ $page->name }}</h5>
                                </div>
                                <div class="card-body">
                                    <p class="card-text">
                                        <strong>Categoria:</strong> {{ $page->category ?? 'Não especificada' }}<br>
                                        <strong>Seguidores:</strong> {{ number_format($page->follower_count) }}<br>
                                        <strong>ID da Página:</strong> {{ $page->facebook_page_id }}<br>
                                        <strong>Adicionada em:</strong> {{ $page->created_at->format('d/m/Y') }}
                                    </p>
                                    
                                    <div class="d-flex justify-content-between mt-3">
                                        <a href="{{ route('pages.show', $page->id) }}" class="btn btn-info">
                                            <i class="bi bi-eye"></i> Detalhes
                                        </a>
                                        <a href="{{ route('videos.import', $page->id) }}" class="btn btn-success">
                                            <i class="bi bi-collection-play"></i> Importar Vídeos
                                        </a>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <form action="{{ route('pages.destroy', $page->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Tem certeza que deseja remover esta página? Todos os vídeos associados também serão removidos.');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-outline-danger">
                                            <i class="bi bi-trash"></i> Remover
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="alert alert-info">
                    <h4 class="alert-heading">Nenhuma página encontrada!</h4>
                    <p>Você ainda não importou nenhuma página do Facebook. Clique no botão "Importar Páginas" para começar.</p>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection
