@extends('layouts.app')

@section('title', 'Comparação de Vídeos - Facebook Video Analytics')

@section('styles')
<style>
    .chart-container {
        position: relative;
        height: 400px;
        margin-bottom: 20px;
    }
    .video-selector {
        max-height: 400px;
        overflow-y: auto;
    }
    .video-card {
        margin-bottom: 10px;
        cursor: pointer;
        transition: all 0.2s;
    }
    .video-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }
    .video-card.selected {
        border: 2px solid #3b5998;
        background-color: rgba(59, 89, 152, 0.1);
    }
    .comparison-table th, .comparison-table td {
        text-align: center;
    }
    .comparison-table th:first-child, .comparison-table td:first-child {
        text-align: left;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1>Comparação de Vídeos</h1>
                <div class="btn-group">
                    <a href="{{ route('metrics.index') }}" class="btn btn-outline-primary">
                        <i class="bi bi-speedometer2"></i> Dashboard
                    </a>
                    <a href="{{ route('metrics.audience') }}" class="btn btn-outline-primary">
                        <i class="bi bi-people"></i> Análise de Público
                    </a>
                    <a href="{{ route('metrics.topics') }}" class="btn btn-outline-primary">
                        <i class="bi bi-tags"></i> Análise de Temas
                    </a>
                </div>
            </div>
            
            <div class="row">
                <!-- Seletor de Vídeos -->
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h5>Selecione Vídeos para Comparar</h5>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('metrics.compare') }}" method="GET" id="compareForm">
                                <div class="mb-3">
                                    <label for="page_filter" class="form-label">Filtrar por Página</label>
                                    <select class="form-select" id="page_filter">
                                        <option value="">Todas as páginas</option>
                                        @foreach($pages as $page)
                                            <option value="{{ $page->id }}">{{ $page->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                
                                <div class="mb-3">
                                    <input type="text" class="form-control" id="video_search" placeholder="Buscar vídeos...">
                                </div>
                                
                                <div class="video-selector">
                                    @foreach($allVideos as $video)
                                        <div class="card video-card" 
                                             data-page-id="{{ $video->page_id }}" 
                                             data-video-id="{{ $video->id }}"
                                             data-video-title="{{ $video->title ?: 'Sem título' }}">
                                            <div class="card-body p-2">
                                                <div class="d-flex align-items-center">
                                                    @if($video->thumbnail_url)
                                                        <img src="{{ $video->thumbnail_url }}" alt="{{ $video->title }}" class="img-thumbnail me-2" style="width: 60px;">
                                                    @else
                                                        <div class="bg-secondary d-flex align-items-center justify-content-center me-2" style="width: 60px; height: 34px;">
                                                            <i class="bi bi-film text-white"></i>
                                                        </div>
                                                    @endif
                                                    <div>
                                                        <h6 class="mb-0">{{ Str::limit($video->title ?: 'Sem título', 30) }}</h6>
                                                        <small class="text-muted">{{ $video->published_at->format('d/m/Y') }} - {{ $video->page->name }}</small>
                                                    </div>
                                                </div>
                                                <div class="form-check mt-2">
                                                    <input class="form-check-input video-checkbox" type="checkbox" name="video_ids[]" value="{{ $video->id }}" id="video_{{ $video->id }}"
                                                        {{ in_array($video->id, request('video_ids', [])) ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="video_{{ $video->id }}">
                                                        Selecionar para comparação
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                                
                                <div class="d-grid gap-2 mt-3">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-bar-chart"></i> Comparar Vídeos Selecionados
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                
                <!-- Resultados da Comparação -->
                <div class="col-md-8">
                    @if(count($videos) > 0)
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5>Comparação de Métricas</h5>
                            </div>
                            <div class="card-body">
                                <div class="chart-container">
                                    <canvas id="comparisonChart"></canvas>
                                </div>
                                
                                <div class="table-responsive mt-4">
                                    <table class="table table-striped comparison-table">
                                        <thead>
                                            <tr>
                                                <th>Métrica</th>
                                                @foreach($videos as $video)
                                                    <th>{{ Str::limit($video->title ?: 'Sem título', 20) }}</th>
                                                @endforeach
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>Visualizações Totais</td>
                                                @foreach($videos as $video)
                                                    @php
                                                        $viewsMetric = isset($metrics[$video->id]) ? 
                                                            ($metrics[$video->id]['total_video_views'] ?? $metrics[$video->id]['views'] ?? null) : null;
                                                        $views = $viewsMetric ? number_format((int)$viewsMetric->metric_value) : 'N/A';
                                                    @endphp
                                                    <td>{{ $views }}</td>
                                                @endforeach
                                            </tr>
                                            <tr>
                                                <td>Visualizações Únicas</td>
                                                @foreach($videos as $video)
                                                    @php
                                                        $uniqueViewsMetric = isset($metrics[$video->id]) ? 
                                                            ($metrics[$video->id]['total_video_views_unique'] ?? null) : null;
                                                        $uniqueViews = $uniqueViewsMetric ? number_format((int)$uniqueViewsMetric->metric_value) : 'N/A';
                                                    @endphp
                                                    <td>{{ $uniqueViews }}</td>
                                                @endforeach
                                            </tr>
                                            <tr>
                                                <td>Visualizações Completas</td>
                                                @foreach($videos as $video)
                                                    @php
                                                        $completeViewsMetric = isset($metrics[$video->id]) ? 
                                                            ($metrics[$video->id]['total_video_complete_views'] ?? null) : null;
                                                        $completeViews = $completeViewsMetric ? number_format((int)$completeViewsMetric->metric_value) : 'N/A';
                                                    @endphp
                                                    <td>{{ $completeViews }}</td>
                                                @endforeach
                                            </tr>
                                            <tr>
                                                <td>Visualizações 30s</td>
                                                @foreach($videos as $video)
                                                    @php
                                                        $views30sMetric = isset($metrics[$video->id]) ? 
                                                            ($metrics[$video->id]['total_video_30s_views'] ?? null) : null;
                                                        $views30s = $views30sMetric ? number_format((int)$views30sMetric->metric_value) : 'N/A';
                                                    @endphp
                                                    <td>{{ $views30s }}</td>
                                                @endforeach
                                            </tr>
                                            <tr>
                                                <td>Tempo Médio Assistido</td>
                                                @foreach($videos as $video)
                                                    @php
                                                        $avgTimeMetric = isset($metrics[$video->id]) ? 
                                                            ($metrics[$video->id]['total_video_avg_time_watched'] ?? null) : null;
                                                        $avgTime = $avgTimeMetric ? gmdate('i:s', (int)$avgTimeMetric->metric_value) : 'N/A';
                                                    @endphp
                                                    <td>{{ $avgTime }}</td>
                                                @endforeach
                                            </tr>
                                            <tr>
                                                <td>Data de Publicação</td>
                                                @foreach($videos as $video)
                                                    <td>{{ $video->published_at->format('d/m/Y') }}</td>
                                                @endforeach
                                            </tr>
                                            <tr>
                                                <td>Duração</td>
                                                @foreach($videos as $video)
                                                    <td>{{ gmdate('i:s', $video->duration) }}</td>
                                                @endforeach
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        
                        <div class="card">
                            <div class="card-header">
                                <h5>Comparação de Público</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    @foreach($videos as $index => $video)
                                        <div class="col-md-6 mb-4">
                                            <h6 class="text-center">{{ $video->title ?: 'Sem título' }}</h6>
                                            <div style="height: 250px;">
                                                <canvas id="audienceChart{{ $index }}"></canvas>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="card">
                            <div class="card-body">
                                <div class="alert alert-info">
                                    <h4 class="alert-heading">Nenhum vídeo selecionado</h4>
                                    <p>Selecione pelo menos um vídeo para visualizar as métricas de comparação.</p>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Filtro de página
        const pageFilter = document.getElementById('page_filter');
        const videoCards = document.querySelectorAll('.video-card');
        
        pageFilter.addEventListener('change', function() {
            const selectedPageId = this.value;
            
            videoCards.forEach(card => {
                const pageId = card.dataset.pageId;
                
                if (!selectedPageId || pageId === selectedPageId) {
                    card.style.display = 'block';
                } else {
                    card.style.display = 'none';
                }
            });
        });
        
        // Busca de vídeos
        const videoSearch = document.getElementById('video_search');
        
        videoSearch.addEventListener('input', function() {
            const searchTerm = this.value.toLowerCase();
            
            videoCards.forEach(card => {
                const title = card.dataset.videoTitle.toLowerCase();
                
                if (title.includes(searchTerm)) {
                    card.style.display = 'block';
                } else {
                    card.style.display = 'none';
                }
            });
     
(Content truncated due to size limit. Use line ranges to read in chunks)