<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VideoTopic extends Model
{
    use HasFactory;

    /**
     * Os atributos que são atribuíveis em massa.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'video_id',
        'topic_id',
        'relevance_score',
    ];

    /**
     * Os atributos que devem ser convertidos.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'relevance_score' => 'float',
    ];

    /**
     * Obtém o vídeo associado.
     */
    public function video()
    {
        return $this->belongsTo(Video::class);
    }

    /**
     * Obtém o tópico associado.
     */
    public function topic()
    {
        return $this->belongsTo(Topic::class);
    }
}
