<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Page extends Model
{
    use HasFactory;

    /**
     * Os atributos que são atribuíveis em massa.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'user_id',
        'facebook_page_id',
        'name',
        'access_token',
        'token_expires_at',
        'category',
        'follower_count',
        'profile_picture_url',
    ];

    /**
     * Os atributos que devem ser convertidos.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'token_expires_at' => 'datetime',
    ];

    /**
     * Obtém o usuário proprietário da página.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Obtém os vídeos associados à página.
     */
    public function videos()
    {
        return $this->hasMany(Video::class);
    }
}
