# Guia para Solicitação de Permissões da Meta para Análise de Vídeos Criativos

Este documento fornece instruções detalhadas sobre como solicitar as permissões necessárias da Meta (Facebook) para acessar a Ad Library API e outras APIs relacionadas para análise de vídeos criativos de terceiros.

## Permissões Necessárias

Para acessar vídeos criativos de anúncios de terceiros, você precisará das seguintes permissões:

1. **Ad Library API Access** - Acesso à biblioteca de anúncios
2. **Page Public Content Access** - Acesso ao conteúdo público de páginas
3. **ads_read** - Permissão para ler dados de anúncios
4. **ads_management** - Permissão para gerenciar anúncios (opcional, dependendo do caso de uso)
5. **business_management** - Permissão para gerenciar negócios (opcional, dependendo do caso de uso)

## Processo de Solicitação

### 1. Criar uma Conta de Desenvolvedor Meta

Se você ainda não possui uma conta de desenvolvedor Meta:

1. Acesse [Meta for Developers](https://developers.facebook.com/)
2. Clique em "Começar" ou "Get Started"
3. Siga as instruções para criar sua conta de desenvolvedor

### 2. Criar um Aplicativo

1. Acesse o [Painel de Desenvolvedores](https://developers.facebook.com/apps/)
2. Clique em "Criar Aplicativo"
3. Selecione o tipo de aplicativo "Negócios"
4. Preencha as informações solicitadas:
   - Nome do aplicativo
   - E-mail de contato
   - Tipo de negócio

### 3. Configurar o Aplicativo

Após criar o aplicativo, você precisará configurá-lo:

1. Na página inicial do aplicativo, adicione os produtos necessários:
   - Marketing API
   - Facebook Login
   - Business SDK

2. Configure o Facebook Login:
   - Adicione URLs de redirecionamento OAuth válidas
   - Configure as configurações básicas

### 4. Solicitar Permissões Adicionais

Para acessar a Ad Library API e outras APIs relacionadas, você precisará passar por um processo de revisão:

1. Acesse "Revisão do Aplicativo" no menu lateral
2. Clique em "Solicitar" ao lado das permissões necessárias:
   - ads_read
   - ads_management (se necessário)
   - business_management (se necessário)
   - Page Public Content Access

3. Para cada permissão, você precisará fornecer:
   - Descrição detalhada de como a permissão será usada
   - Capturas de tela do fluxo do usuário
   - Vídeo demonstrativo (para algumas permissões)

### 5. Solicitar Acesso à Ad Library API

O acesso à Ad Library API requer um processo de aprovação separado:

1. Acesse [Meta for Developers - Ad Library API](https://developers.facebook.com/docs/marketing-api/reference/ads_archive/)
2. Clique no link para solicitar acesso
3. Preencha o formulário de solicitação, incluindo:
   - Detalhes do aplicativo
   - Caso de uso detalhado
   - Informações da empresa/organização
   - Como os dados serão usados
   - Medidas de segurança implementadas

### 6. Preparar a Documentação Necessária

Para aumentar as chances de aprovação, prepare:

1. **Descrição detalhada do caso de uso**:
   - Explique claramente como você usará os dados de vídeos criativos
   - Destaque os benefícios para os usuários
   - Explique como você respeitará a privacidade dos dados

2. **Capturas de tela do aplicativo**:
   - Interface de usuário mostrando como os dados serão exibidos
   - Fluxo de autenticação
   - Funcionalidades principais

3. **Vídeo demonstrativo**:
   - Demonstração do aplicativo em funcionamento
   - Explicação das funcionalidades
   - Como as permissões solicitadas são utilizadas

4. **Política de privacidade**:
   - Documento detalhando como os dados serão tratados
   - Medidas de segurança implementadas
   - Conformidade com regulamentações (LGPD, GDPR, etc.)

## Requisitos Específicos para Análise de Vídeos Criativos

Para análise de vídeos criativos de terceiros, a Meta tem requisitos específicos:

1. **Justificativa clara**: Explique por que você precisa analisar vídeos criativos de terceiros
2. **Limitação de uso**: Detalhe como você limitará o uso dos dados apenas para os fins declarados
3. **Transparência**: Explique como você informará os usuários sobre a origem dos dados
4. **Conformidade**: Demonstre conformidade com as políticas da Meta e regulamentações de privacidade

## Tempo de Aprovação

O processo de aprovação pode levar de algumas semanas a alguns meses, dependendo:

- Complexidade do caso de uso
- Clareza da documentação fornecida
- Volume de solicitações que a Meta está processando
- Sensibilidade das permissões solicitadas

## Melhores Práticas para Aprovação

1. **Seja específico**: Forneça detalhes concretos sobre como cada permissão será usada
2. **Seja transparente**: Não tente ocultar o verdadeiro propósito do aplicativo
3. **Seja completo**: Forneça toda a documentação solicitada
4. **Seja paciente**: O processo pode levar tempo; esteja preparado para responder a perguntas adicionais
5. **Seja persistente**: Se sua solicitação for negada, peça feedback e tente novamente com as correções necessárias

## Alternativas Durante o Processo de Aprovação

Enquanto aguarda a aprovação, você pode:

1. **Usar dados simulados**: Como implementado nesta aplicação
2. **Limitar o escopo**: Comece com permissões mais básicas que são mais fáceis de obter
3. **Usar APIs públicas**: Algumas APIs têm acesso mais fácil e podem fornecer dados limitados

## Manutenção das Permissões

Após obter as permissões:

1. **Revisões periódicas**: A Meta realiza revisões periódicas para garantir que você ainda está usando as permissões conforme declarado
2. **Atualizações de política**: Fique atento às mudanças nas políticas da Meta que podem afetar suas permissões
3. **Renovação**: Algumas permissões podem exigir renovação periódica

## Contato e Suporte

Se você encontrar dificuldades durante o processo:

1. **Suporte ao desenvolvedor**: Use o [suporte ao desenvolvedor da Meta](https://developers.facebook.com/support/)
2. **Fóruns da comunidade**: Participe dos fóruns da comunidade de desenvolvedores
3. **Consultoria especializada**: Considere contratar consultores especializados em APIs da Meta para ajudar no processo de aprovação

## Próximos Passos

Após obter as permissões necessárias:

1. Atualize o arquivo `.env` com suas credenciais
2. Substitua os dados simulados por chamadas reais à API
3. Teste exaustivamente as funcionalidades com dados reais
4. Implante a versão final em um ambiente de produção seguro
