<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Laravel\Socialite\Facades\Socialite;

class FacebookController extends Controller
{
    /**
     * Redireciona o usuário para a página de autenticação do Facebook.
     *
     * @return \Illuminate\Http\Response
     */
    public function redirectToFacebook()
    {
        return Socialite::driver('facebook')
            ->scopes(['pages_read_engagement', 'read_insights', 'pages_show_list'])
            ->redirect();
    }

    /**
     * Obtém as informações do usuário do Facebook após a autenticação.
     *
     * @return \Illuminate\Http\Response
     */
    public function handleFacebookCallback()
    {
        try {
            $facebookUser = Socialite::driver('facebook')->user();
            
            // Calcular data de expiração do token
            $expiresAt = null;
            if (isset($facebookUser->expiresIn)) {
                $expiresAt = Carbon::now()->addSeconds($facebookUser->expiresIn);
            }
            
            // Encontrar ou criar usuário
            $user = User::updateOrCreate(
                ['facebook_id' => $facebookUser->id],
                [
                    'name' => $facebookUser->name,
                    'email' => $facebookUser->email ?? $facebookUser->id . '@facebook.com',
                    'facebook_token' => $facebookUser->token,
                    'facebook_token_expires_at' => $expiresAt,
                    'avatar' => $facebookUser->avatar,
                    'password' => bcrypt(rand(1, 10000)), // senha aleatória
                ]
            );
            
            Auth::login($user);
            
            return redirect()->route('dashboard');
            
        } catch (\Exception $e) {
            return redirect()->route('login')
                ->with('error', 'Erro ao autenticar com Facebook: ' . $e->getMessage());
        }
    }
}
