# Documentação de Implantação - Facebook Video Analytics

Este documento fornece instruções detalhadas para implantar a aplicação Facebook Video Analytics em um ambiente de produção.

## Requisitos do Servidor

- PHP 8.1 ou superior
- MySQL 8.0 ou superior
- Composer
- Node.js e NPM
- Servidor web (Apache ou Nginx)
- Certificado SSL (obrigatório para aplicativos Facebook)

## Passos para Implantação

### 1. Configuração do Servidor

```bash
# Atualizar pacotes
sudo apt update
sudo apt upgrade -y

# Instalar dependências
sudo apt install -y php8.1 php8.1-cli php8.1-common php8.1-mysql php8.1-zip php8.1-gd php8.1-mbstring php8.1-curl php8.1-xml php8.1-bcmath
sudo apt install -y mysql-server
sudo apt install -y nodejs npm
sudo apt install -y nginx

# Configurar MySQL
sudo mysql_secure_installation
```

### 2. Configuração do Aplicativo Facebook

1. Acesse [Facebook Developers](https://developers.facebook.com/)
2. Crie um novo aplicativo
3. Configure as seguintes permissões:
   - `pages_read_engagement`
   - `read_insights`
4. Configure a URL de callback: `https://seu-dominio.com/auth/facebook/callback`
5. Anote o App ID e App Secret

### 3. Implantação do Código

```bash
# Clonar o repositório
git clone [URL_DO_REPOSITÓRIO] /var/www/facebook-video-analytics

# Instalar dependências PHP
cd /var/www/facebook-video-analytics
composer install --optimize-autoloader --no-dev

# Instalar dependências JavaScript
npm install
npm run build

# Configurar permissões
sudo chown -R www-data:www-data /var/www/facebook-video-analytics
sudo chmod -R 755 /var/www/facebook-video-analytics
sudo chmod -R 777 /var/www/facebook-video-analytics/storage
```

### 4. Configuração do Ambiente

Crie o arquivo `.env` baseado no `.env.example` e configure:

```
APP_NAME="Facebook Video Analytics"
APP_ENV=production
APP_KEY=[GERAR_COM_ARTISAN]
APP_DEBUG=false
APP_URL=https://seu-dominio.com

DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=facebook_video_analytics
DB_USERNAME=[USUARIO_MYSQL]
DB_PASSWORD=[SENHA_MYSQL]

FACEBOOK_CLIENT_ID=[APP_ID]
FACEBOOK_CLIENT_SECRET=[APP_SECRET]
FACEBOOK_REDIRECT=https://seu-dominio.com/auth/facebook/callback
```

Gere a chave da aplicação:

```bash
php artisan key:generate
```

### 5. Configuração do Banco de Dados

```bash
# Criar banco de dados
sudo mysql -e "CREATE DATABASE facebook_video_analytics CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;"
sudo mysql -e "CREATE USER '[USUARIO_MYSQL]'@'localhost' IDENTIFIED BY '[SENHA_MYSQL]';"
sudo mysql -e "GRANT ALL PRIVILEGES ON facebook_video_analytics.* TO '[USUARIO_MYSQL]'@'localhost';"
sudo mysql -e "FLUSH PRIVILEGES;"

# Executar migrações
php artisan migrate
```

### 6. Configuração do Nginx

Crie um arquivo de configuração para o site:

```bash
sudo nano /etc/nginx/sites-available/facebook-video-analytics
```

Adicione o seguinte conteúdo:

```nginx
server {
    listen 80;
    server_name seu-dominio.com;
    return 301 https://$host$request_uri;
}

server {
    listen 443 ssl;
    server_name seu-dominio.com;
    
    ssl_certificate /etc/letsencrypt/live/seu-dominio.com/fullchain.pem;
    ssl_certificate_key /etc/letsencrypt/live/seu-dominio.com/privkey.pem;
    
    root /var/www/facebook-video-analytics/public;
    
    add_header X-Frame-Options "SAMEORIGIN";
    add_header X-Content-Type-Options "nosniff";
    
    index index.php;
    
    charset utf-8;
    
    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }
    
    location = /favicon.ico { access_log off; log_not_found off; }
    location = /robots.txt  { access_log off; log_not_found off; }
    
    error_page 404 /index.php;
    
    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php8.1-fpm.sock;
        fastcgi_param SCRIPT_FILENAME $realpath_root$fastcgi_script_name;
        include fastcgi_params;
    }
    
    location ~ /\.(?!well-known).* {
        deny all;
    }
}
```

Ative o site:

```bash
sudo ln -s /etc/nginx/sites-available/facebook-video-analytics /etc/nginx/sites-enabled/
sudo nginx -t
sudo systemctl restart nginx
```

### 7. Configuração do SSL com Let's Encrypt

```bash
sudo apt install -y certbot python3-certbot-nginx
sudo certbot --nginx -d seu-dominio.com
```

### 8. Configuração de Tarefas Agendadas

Adicione ao crontab para executar tarefas agendadas:

```bash
sudo crontab -e
```

Adicione a linha:

```
* * * * * cd /var/www/facebook-video-analytics && php artisan schedule:run >> /dev/null 2>&1
```

### 9. Otimização para Produção

```bash
# Otimizar configurações
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

## Manutenção

### Atualização da Aplicação

```bash
cd /var/www/facebook-video-analytics
git pull
composer install --optimize-autoloader --no-dev
npm install
npm run build
php artisan migrate
php artisan config:cache
php artisan route:cache
php artisan view:cache
sudo chown -R www-data:www-data /var/www/facebook-video-analytics
```

### Backup do Banco de Dados

```bash
mysqldump -u [USUARIO_MYSQL] -p facebook_video_analytics > backup_$(date +%Y%m%d).sql
```

## Solução de Problemas

### Verificar Logs

```bash
# Logs do Laravel
tail -f /var/www/facebook-video-analytics/storage/logs/laravel.log

# Logs do Nginx
tail -f /var/log/nginx/error.log

# Logs do PHP
tail -f /var/log/php8.1-fpm.log
```

### Reiniciar Serviços

```bash
sudo systemctl restart nginx
sudo systemctl restart php8.1-fpm
sudo systemctl restart mysql
```

## Contato para Suporte

Para suporte técnico, entre em contato com:
- Email: suporte@exemplo.com
- Telefone: (00) 0000-0000
