<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AudienceSegment extends Model
{
    use HasFactory;

    /**
     * Os atributos que são atribuíveis em massa.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'video_id',
        'segment_type',
        'segment_value',
        'view_count',
        'engagement_rate',
    ];

    /**
     * Os atributos que devem ser convertidos.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'view_count' => 'integer',
        'engagement_rate' => 'float',
    ];

    /**
     * Obtém o vídeo ao qual o segmento de público pertence.
     */
    public function video()
    {
        return $this->belongsTo(Video::class);
    }
}
